package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OptionGroupOption(
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    majorEngineVersion: Optional[String] = Optional.Absent,
    minimumRequiredMinorEngineVersion: Optional[String] = Optional.Absent,
    portRequired: Optional[Boolean] = Optional.Absent,
    defaultPort: Optional[IntegerOptional] = Optional.Absent,
    optionsDependedOn: Optional[Iterable[String]] = Optional.Absent,
    optionsConflictsWith: Optional[Iterable[String]] = Optional.Absent,
    persistent: Optional[Boolean] = Optional.Absent,
    permanent: Optional[Boolean] = Optional.Absent,
    requiresAutoMinorEngineVersionUpgrade: Optional[Boolean] = Optional.Absent,
    vpcOnly: Optional[Boolean] = Optional.Absent,
    supportsOptionVersionDowngrade: Optional[BooleanOptional] = Optional.Absent,
    optionGroupOptionSettings: Optional[
      Iterable[zio.aws.rds.model.OptionGroupOptionSetting]
    ] = Optional.Absent,
    optionGroupOptionVersions: Optional[
      Iterable[zio.aws.rds.model.OptionVersion]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupOption = {
    import OptionGroupOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupOption
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        minimumRequiredMinorEngineVersion.map(value => value: java.lang.String)
      )(_.minimumRequiredMinorEngineVersion)
      .optionallyWith(portRequired.map(value => value: java.lang.Boolean))(
        _.portRequired
      )
      .optionallyWith(defaultPort.map(value => value: Integer))(_.defaultPort)
      .optionallyWith(
        optionsDependedOn.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.optionsDependedOn)
      .optionallyWith(
        optionsConflictsWith.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.optionsConflictsWith)
      .optionallyWith(persistent.map(value => value: java.lang.Boolean))(
        _.persistent
      )
      .optionallyWith(permanent.map(value => value: java.lang.Boolean))(
        _.permanent
      )
      .optionallyWith(
        requiresAutoMinorEngineVersionUpgrade.map(value =>
          value: java.lang.Boolean
        )
      )(_.requiresAutoMinorEngineVersionUpgrade)
      .optionallyWith(vpcOnly.map(value => value: java.lang.Boolean))(_.vpcOnly)
      .optionallyWith(
        supportsOptionVersionDowngrade.map(value => value: java.lang.Boolean)
      )(_.supportsOptionVersionDowngrade)
      .optionallyWith(
        optionGroupOptionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptionSettings)
      .optionallyWith(
        optionGroupOptionVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptionVersions)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupOption.ReadOnly =
    zio.aws.rds.model.OptionGroupOption.wrap(buildAwsValue())
}
object OptionGroupOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupOption =
      zio.aws.rds.model.OptionGroupOption(
        name.map(value => value),
        description.map(value => value),
        engineName.map(value => value),
        majorEngineVersion.map(value => value),
        minimumRequiredMinorEngineVersion.map(value => value),
        portRequired.map(value => value),
        defaultPort.map(value => value),
        optionsDependedOn.map(value => value),
        optionsConflictsWith.map(value => value),
        persistent.map(value => value),
        permanent.map(value => value),
        requiresAutoMinorEngineVersionUpgrade.map(value => value),
        vpcOnly.map(value => value),
        supportsOptionVersionDowngrade.map(value => value),
        optionGroupOptionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionGroupOptionVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def description: Optional[String]
    def engineName: Optional[String]
    def majorEngineVersion: Optional[String]
    def minimumRequiredMinorEngineVersion: Optional[String]
    def portRequired: Optional[Boolean]
    def defaultPort: Optional[IntegerOptional]
    def optionsDependedOn: Optional[List[String]]
    def optionsConflictsWith: Optional[List[String]]
    def persistent: Optional[Boolean]
    def permanent: Optional[Boolean]
    def requiresAutoMinorEngineVersionUpgrade: Optional[Boolean]
    def vpcOnly: Optional[Boolean]
    def supportsOptionVersionDowngrade: Optional[BooleanOptional]
    def optionGroupOptionSettings
        : Optional[List[zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly]]
    def optionGroupOptionVersions
        : Optional[List[zio.aws.rds.model.OptionVersion.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getMinimumRequiredMinorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "minimumRequiredMinorEngineVersion",
        minimumRequiredMinorEngineVersion
      )
    def getPortRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("portRequired", portRequired)
    def getDefaultPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("defaultPort", defaultPort)
    def getOptionsDependedOn: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("optionsDependedOn", optionsDependedOn)
    def getOptionsConflictsWith: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("optionsConflictsWith", optionsConflictsWith)
    def getPersistent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("persistent", persistent)
    def getPermanent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanent", permanent)
    def getRequiresAutoMinorEngineVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requiresAutoMinorEngineVersionUpgrade",
        requiresAutoMinorEngineVersionUpgrade
      )
    def getVpcOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpcOnly", vpcOnly)
    def getSupportsOptionVersionDowngrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsOptionVersionDowngrade",
        supportsOptionVersionDowngrade
      )
    def getOptionGroupOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupOptionSettings",
      optionGroupOptionSettings
    )
    def getOptionGroupOptionVersions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionVersion.ReadOnly]] =
      AwsError.unwrapOptionField(
        "optionGroupOptionVersions",
        optionGroupOptionVersions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOption
  ) extends zio.aws.rds.model.OptionGroupOption.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val majorEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.majorEngineVersion())
      .map(value => value: String)
    override val minimumRequiredMinorEngineVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumRequiredMinorEngineVersion())
        .map(value => value: String)
    override val portRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.portRequired())
      .map(value => value: Boolean)
    override val defaultPort: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultPort())
      .map(value => value: IntegerOptional)
    override val optionsDependedOn: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionsDependedOn())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val optionsConflictsWith: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionsConflictsWith())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val persistent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.persistent())
      .map(value => value: Boolean)
    override val permanent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.permanent())
      .map(value => value: Boolean)
    override val requiresAutoMinorEngineVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresAutoMinorEngineVersionUpgrade())
        .map(value => value: Boolean)
    override val vpcOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcOnly())
      .map(value => value: Boolean)
    override val supportsOptionVersionDowngrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsOptionVersionDowngrade())
        .map(value => value: BooleanOptional)
    override val optionGroupOptionSettings
        : Optional[List[zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupOptionSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroupOptionSetting.wrap(item)
          }.toList
        )
    override val optionGroupOptionVersions
        : Optional[List[zio.aws.rds.model.OptionVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupOptionVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionVersion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOption
  ): zio.aws.rds.model.OptionGroupOption.ReadOnly = new Wrapper(impl)
}
