package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyOptionGroupRequest(
    optionGroupName: String,
    optionsToInclude: Optional[
      Iterable[zio.aws.rds.model.OptionConfiguration]
    ] = Optional.Absent,
    optionsToRemove: Optional[Iterable[String]] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest = {
    import ModifyOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest
      .builder()
      .optionGroupName(optionGroupName: java.lang.String)
      .optionallyWith(
        optionsToInclude.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionsToInclude)
      .optionallyWith(
        optionsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.optionsToRemove)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyOptionGroupRequest.ReadOnly =
    zio.aws.rds.model.ModifyOptionGroupRequest.wrap(buildAwsValue())
}
object ModifyOptionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyOptionGroupRequest =
      zio.aws.rds.model.ModifyOptionGroupRequest(
        optionGroupName,
        optionsToInclude.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionsToRemove.map(value => value),
        applyImmediately.map(value => value)
      )
    def optionGroupName: String
    def optionsToInclude
        : Optional[List[zio.aws.rds.model.OptionConfiguration.ReadOnly]]
    def optionsToRemove: Optional[List[String]]
    def applyImmediately: Optional[Boolean]
    def getOptionGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(optionGroupName)
    def getOptionsToInclude: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("optionsToInclude", optionsToInclude)
    def getOptionsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("optionsToRemove", optionsToRemove)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest
  ) extends zio.aws.rds.model.ModifyOptionGroupRequest.ReadOnly {
    override val optionGroupName: String = impl.optionGroupName(): String
    override val optionsToInclude
        : Optional[List[zio.aws.rds.model.OptionConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionsToInclude())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionConfiguration.wrap(item)
          }.toList
        )
    override val optionsToRemove: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.optionsToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest
  ): zio.aws.rds.model.ModifyOptionGroupRequest.ReadOnly = new Wrapper(impl)
}
