package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbSnapshotAttributeResponse(
    dbSnapshotAttributesResult: Optional[
      zio.aws.rds.model.DBSnapshotAttributesResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse = {
    import ModifyDbSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse
      .builder()
      .optionallyWith(
        dbSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbSnapshotAttributesResult)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.wrap(buildAwsValue())
}
object ModifyDbSnapshotAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSnapshotAttributeResponse =
      zio.aws.rds.model.ModifyDbSnapshotAttributeResponse(
        dbSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbSnapshotAttributesResult
        : Optional[zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly]
    def getDbSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbSnapshotAttributesResult",
      dbSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse
  ) extends zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly {
    override val dbSnapshotAttributesResult
        : Optional[zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSnapshotAttributesResult())
        .map(value => zio.aws.rds.model.DBSnapshotAttributesResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse
  ): zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
