package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyCurrentDbClusterCapacityResponse(
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    pendingCapacity: Optional[IntegerOptional] = Optional.Absent,
    currentCapacity: Optional[IntegerOptional] = Optional.Absent,
    secondsBeforeTimeout: Optional[IntegerOptional] = Optional.Absent,
    timeoutAction: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse = {
    import ModifyCurrentDbClusterCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(pendingCapacity.map(value => value: Integer))(
        _.pendingCapacity
      )
      .optionallyWith(currentCapacity.map(value => value: Integer))(
        _.currentCapacity
      )
      .optionallyWith(secondsBeforeTimeout.map(value => value: Integer))(
        _.secondsBeforeTimeout
      )
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly =
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse
      .wrap(buildAwsValue())
}
object ModifyCurrentDbClusterCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse =
      zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse(
        dbClusterIdentifier.map(value => value),
        pendingCapacity.map(value => value),
        currentCapacity.map(value => value),
        secondsBeforeTimeout.map(value => value),
        timeoutAction.map(value => value)
      )
    def dbClusterIdentifier: Optional[String]
    def pendingCapacity: Optional[IntegerOptional]
    def currentCapacity: Optional[IntegerOptional]
    def secondsBeforeTimeout: Optional[IntegerOptional]
    def timeoutAction: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getPendingCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("pendingCapacity", pendingCapacity)
    def getCurrentCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("currentCapacity", currentCapacity)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ) extends zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly {
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val pendingCapacity: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingCapacity())
        .map(value => value: IntegerOptional)
    override val currentCapacity: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentCapacity())
        .map(value => value: IntegerOptional)
    override val secondsBeforeTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondsBeforeTimeout())
        .map(value => value: IntegerOptional)
    override val timeoutAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutAction())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse
  ): zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
