package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOptionGroupsResponse(
    optionGroupsList: Optional[Iterable[zio.aws.rds.model.OptionGroup]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse = {
    import DescribeOptionGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
      .builder()
      .optionallyWith(
        optionGroupsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupsList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupsResponse.wrap(buildAwsValue())
}
object DescribeOptionGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupsResponse =
      zio.aws.rds.model.DescribeOptionGroupsResponse(
        optionGroupsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def optionGroupsList: Optional[List[zio.aws.rds.model.OptionGroup.ReadOnly]]
    def marker: Optional[String]
    def getOptionGroupsList
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionGroup.ReadOnly]] =
      AwsError.unwrapOptionField("optionGroupsList", optionGroupsList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ) extends zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly {
    override val optionGroupsList
        : Optional[List[zio.aws.rds.model.OptionGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroup.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse
  ): zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly = new Wrapper(impl)
}
