package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAttributesResponse(
    accountQuotas: Optional[Iterable[zio.aws.rds.model.AccountQuota]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(
        accountQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountQuotas)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.rds.model.DescribeAccountAttributesResponse.wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeAccountAttributesResponse =
      zio.aws.rds.model.DescribeAccountAttributesResponse(
        accountQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountQuotas: Optional[List[zio.aws.rds.model.AccountQuota.ReadOnly]]
    def getAccountQuotas
        : ZIO[Any, AwsError, List[zio.aws.rds.model.AccountQuota.ReadOnly]] =
      AwsError.unwrapOptionField("accountQuotas", accountQuotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse
  ) extends zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly {
    override val accountQuotas
        : Optional[List[zio.aws.rds.model.AccountQuota.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.AccountQuota.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse
  ): zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly = new Wrapper(
    impl
  )
}
