package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDbInstanceAutomatedBackupResponse(
    dbInstanceAutomatedBackup: Optional[
      zio.aws.rds.model.DBInstanceAutomatedBackup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse = {
    import DeleteDbInstanceAutomatedBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse
      .builder()
      .optionallyWith(
        dbInstanceAutomatedBackup.map(value => value.buildAwsValue())
      )(_.dbInstanceAutomatedBackup)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse
      .wrap(buildAwsValue())
}
object DeleteDbInstanceAutomatedBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse =
      zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse(
        dbInstanceAutomatedBackup.map(value => value.asEditable)
      )
    def dbInstanceAutomatedBackup
        : Optional[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly]
    def getDbInstanceAutomatedBackup: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackup",
      dbInstanceAutomatedBackup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse
  ) extends zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly {
    override val dbInstanceAutomatedBackup
        : Optional[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackup())
        .map(value => zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse
  ): zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly =
    new Wrapper(impl)
}
