package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBSubnetGroup(
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    dbSubnetGroupDescription: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    subnetGroupStatus: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[zio.aws.rds.model.Subnet]] = Optional.Absent,
    dbSubnetGroupArn: Optional[String] = Optional.Absent,
    supportedNetworkTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSubnetGroup = {
    import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSubnetGroup
      .builder()
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(
        _.dbSubnetGroupArn
      )
      .optionallyWith(
        supportedNetworkTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedNetworkTypes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSubnetGroup.ReadOnly =
    zio.aws.rds.model.DBSubnetGroup.wrap(buildAwsValue())
}
object DBSubnetGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBSubnetGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSubnetGroup =
      zio.aws.rds.model.DBSubnetGroup(
        dbSubnetGroupName.map(value => value),
        dbSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupArn.map(value => value),
        supportedNetworkTypes.map(value => value)
      )
    def dbSubnetGroupName: Optional[String]
    def dbSubnetGroupDescription: Optional[String]
    def vpcId: Optional[String]
    def subnetGroupStatus: Optional[String]
    def subnets: Optional[List[zio.aws.rds.model.Subnet.ReadOnly]]
    def dbSubnetGroupArn: Optional[String]
    def supportedNetworkTypes: Optional[List[String]]
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getDbSubnetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArn)
    def getSupportedNetworkTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedNetworkTypes", supportedNetworkTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup
  ) extends zio.aws.rds.model.DBSubnetGroup.ReadOnly {
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val dbSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroupDescription())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnetGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupStatus())
      .map(value => value: String)
    override val subnets: Optional[List[zio.aws.rds.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Subnet.wrap(item)
          }.toList
        )
    override val dbSubnetGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupArn())
      .map(value => value: String)
    override val supportedNetworkTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedNetworkTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup
  ): zio.aws.rds.model.DBSubnetGroup.ReadOnly = new Wrapper(impl)
}
