package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBSnapshotAttribute(
    attributeName: Optional[String] = Optional.Absent,
    attributeValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSnapshotAttribute = {
    import DBSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSnapshotAttribute
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeValues)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSnapshotAttribute.ReadOnly =
    zio.aws.rds.model.DBSnapshotAttribute.wrap(buildAwsValue())
}
object DBSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBSnapshotAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSnapshotAttribute =
      zio.aws.rds.model.DBSnapshotAttribute(
        attributeName.map(value => value),
        attributeValues.map(value => value)
      )
    def attributeName: Optional[String]
    def attributeValues: Optional[List[String]]
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeValues", attributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttribute
  ) extends zio.aws.rds.model.DBSnapshotAttribute.ReadOnly {
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val attributeValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttribute
  ): zio.aws.rds.model.DBSnapshotAttribute.ReadOnly = new Wrapper(impl)
}
