package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  Integer,
  TStamp
}
import scala.jdk.CollectionConverters.*
final case class DBInstance(
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    dbInstanceStatus: Optional[String] = Optional.Absent,
    automaticRestartTime: Optional[TStamp] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    endpoint: Optional[zio.aws.rds.model.Endpoint] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    dbSecurityGroups: Optional[
      Iterable[zio.aws.rds.model.DBSecurityGroupMembership]
    ] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.rds.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    dbParameterGroups: Optional[
      Iterable[zio.aws.rds.model.DBParameterGroupStatus]
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[zio.aws.rds.model.PendingModifiedValues] =
      Optional.Absent,
    latestRestorableTime: Optional[TStamp] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    readReplicaSourceDBInstanceIdentifier: Optional[String] = Optional.Absent,
    readReplicaDBInstanceIdentifiers: Optional[Iterable[String]] =
      Optional.Absent,
    readReplicaDBClusterIdentifiers: Optional[Iterable[String]] =
      Optional.Absent,
    replicaMode: Optional[zio.aws.rds.model.ReplicaMode] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupMemberships: Optional[
      Iterable[zio.aws.rds.model.OptionGroupMembership]
    ] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    ncharCharacterSetName: Optional[String] = Optional.Absent,
    secondaryAvailabilityZone: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    statusInfos: Optional[Iterable[zio.aws.rds.model.DBInstanceStatusInfo]] =
      Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    dbInstancePort: Optional[Integer] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbiResourceId: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    domainMemberships: Optional[Iterable[zio.aws.rds.model.DomainMembership]] =
      Optional.Absent,
    copyTagsToSnapshot: Optional[Boolean] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    enhancedMonitoringResourceArn: Optional[String] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceArn: Optional[String] = Optional.Absent,
    timezone: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    performanceInsightsEnabled: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    enabledCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    deletionProtection: Optional[Boolean] = Optional.Absent,
    associatedRoles: Optional[Iterable[zio.aws.rds.model.DBInstanceRole]] =
      Optional.Absent,
    listenerEndpoint: Optional[zio.aws.rds.model.Endpoint] = Optional.Absent,
    maxAllocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    dbInstanceAutomatedBackupsReplications: Optional[
      Iterable[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication]
    ] = Optional.Absent,
    customerOwnedIpEnabled: Optional[BooleanOptional] = Optional.Absent,
    awsBackupRecoveryPointArn: Optional[String] = Optional.Absent,
    activityStreamStatus: Optional[zio.aws.rds.model.ActivityStreamStatus] =
      Optional.Absent,
    activityStreamKmsKeyId: Optional[String] = Optional.Absent,
    activityStreamKinesisStreamName: Optional[String] = Optional.Absent,
    activityStreamMode: Optional[zio.aws.rds.model.ActivityStreamMode] =
      Optional.Absent,
    activityStreamEngineNativeAuditFieldsIncluded: Optional[BooleanOptional] =
      Optional.Absent,
    automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      Optional.Absent,
    resumeFullAutomationModeTime: Optional[TStamp] = Optional.Absent,
    customIamInstanceProfile: Optional[String] = Optional.Absent,
    backupTarget: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstance
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(
        _.dbInstanceStatus
      )
      .optionallyWith(
        automaticRestartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.automaticRestartTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        readReplicaSourceDBInstanceIdentifier.map(value =>
          value: java.lang.String
        )
      )(_.readReplicaSourceDBInstanceIdentifier)
      .optionallyWith(
        readReplicaDBInstanceIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBInstanceIdentifiers)
      .optionallyWith(
        readReplicaDBClusterIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBClusterIdentifiers)
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupMemberships)
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        ncharCharacterSetName.map(value => value: java.lang.String)
      )(_.ncharCharacterSetName)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(dbInstancePort.map(value => value: java.lang.Integer))(
        _.dbInstancePort
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value => value: java.lang.Integer)
      )(_.monitoringInterval)
      .optionallyWith(
        enhancedMonitoringResourceArn.map(value => value: java.lang.String)
      )(_.enhancedMonitoringResourceArn)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          value: java.lang.Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(listenerEndpoint.map(value => value.buildAwsValue()))(
        _.listenerEndpoint
      )
      .optionallyWith(
        maxAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.maxAllocatedStorage)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        dbInstanceAutomatedBackupsReplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbInstanceAutomatedBackupsReplications)
      .optionallyWith(
        customerOwnedIpEnabled.map(value => value: java.lang.Boolean)
      )(_.customerOwnedIpEnabled)
      .optionallyWith(
        awsBackupRecoveryPointArn.map(value => value: java.lang.String)
      )(_.awsBackupRecoveryPointArn)
      .optionallyWith(activityStreamStatus.map(value => value.unwrap))(
        _.activityStreamStatus
      )
      .optionallyWith(
        activityStreamKmsKeyId.map(value => value: java.lang.String)
      )(_.activityStreamKmsKeyId)
      .optionallyWith(
        activityStreamKinesisStreamName.map(value => value: java.lang.String)
      )(_.activityStreamKinesisStreamName)
      .optionallyWith(activityStreamMode.map(value => value.unwrap))(
        _.activityStreamMode
      )
      .optionallyWith(
        activityStreamEngineNativeAuditFieldsIncluded.map(value =>
          value: java.lang.Boolean
        )
      )(_.activityStreamEngineNativeAuditFieldsIncluded)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeTime.map(value => TStamp.unwrap(value): Instant)
      )(_.resumeFullAutomationModeTime)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstance.ReadOnly =
    zio.aws.rds.model.DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstance = zio.aws.rds.model.DBInstance(
      dbInstanceIdentifier.map(value => value),
      dbInstanceClass.map(value => value),
      engine.map(value => value),
      dbInstanceStatus.map(value => value),
      automaticRestartTime.map(value => value),
      masterUsername.map(value => value),
      dbName.map(value => value),
      endpoint.map(value => value.asEditable),
      allocatedStorage.map(value => value),
      instanceCreateTime.map(value => value),
      preferredBackupWindow.map(value => value),
      backupRetentionPeriod.map(value => value),
      dbSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbParameterGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      dbSubnetGroup.map(value => value.asEditable),
      preferredMaintenanceWindow.map(value => value),
      pendingModifiedValues.map(value => value.asEditable),
      latestRestorableTime.map(value => value),
      multiAZ.map(value => value),
      engineVersion.map(value => value),
      autoMinorVersionUpgrade.map(value => value),
      readReplicaSourceDBInstanceIdentifier.map(value => value),
      readReplicaDBInstanceIdentifiers.map(value => value),
      readReplicaDBClusterIdentifiers.map(value => value),
      replicaMode.map(value => value),
      licenseModel.map(value => value),
      iops.map(value => value),
      optionGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      characterSetName.map(value => value),
      ncharCharacterSetName.map(value => value),
      secondaryAvailabilityZone.map(value => value),
      publiclyAccessible.map(value => value),
      statusInfos.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      storageType.map(value => value),
      tdeCredentialArn.map(value => value),
      dbInstancePort.map(value => value),
      dbClusterIdentifier.map(value => value),
      storageEncrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbiResourceId.map(value => value),
      caCertificateIdentifier.map(value => value),
      domainMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      copyTagsToSnapshot.map(value => value),
      monitoringInterval.map(value => value),
      enhancedMonitoringResourceArn.map(value => value),
      monitoringRoleArn.map(value => value),
      promotionTier.map(value => value),
      dbInstanceArn.map(value => value),
      timezone.map(value => value),
      iamDatabaseAuthenticationEnabled.map(value => value),
      performanceInsightsEnabled.map(value => value),
      performanceInsightsKMSKeyId.map(value => value),
      performanceInsightsRetentionPeriod.map(value => value),
      enabledCloudwatchLogsExports.map(value => value),
      processorFeatures.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      deletionProtection.map(value => value),
      associatedRoles.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      listenerEndpoint.map(value => value.asEditable),
      maxAllocatedStorage.map(value => value),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbInstanceAutomatedBackupsReplications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      customerOwnedIpEnabled.map(value => value),
      awsBackupRecoveryPointArn.map(value => value),
      activityStreamStatus.map(value => value),
      activityStreamKmsKeyId.map(value => value),
      activityStreamKinesisStreamName.map(value => value),
      activityStreamMode.map(value => value),
      activityStreamEngineNativeAuditFieldsIncluded.map(value => value),
      automationMode.map(value => value),
      resumeFullAutomationModeTime.map(value => value),
      customIamInstanceProfile.map(value => value),
      backupTarget.map(value => value),
      networkType.map(value => value)
    )
    def dbInstanceIdentifier: Optional[String]
    def dbInstanceClass: Optional[String]
    def engine: Optional[String]
    def dbInstanceStatus: Optional[String]
    def automaticRestartTime: Optional[TStamp]
    def masterUsername: Optional[String]
    def dbName: Optional[String]
    def endpoint: Optional[zio.aws.rds.model.Endpoint.ReadOnly]
    def allocatedStorage: Optional[Integer]
    def instanceCreateTime: Optional[TStamp]
    def preferredBackupWindow: Optional[String]
    def backupRetentionPeriod: Optional[Integer]
    def dbSecurityGroups
        : Optional[List[zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly]]
    def vpcSecurityGroups
        : Optional[List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]]
    def dbParameterGroups
        : Optional[List[zio.aws.rds.model.DBParameterGroupStatus.ReadOnly]]
    def availabilityZone: Optional[String]
    def dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues
        : Optional[zio.aws.rds.model.PendingModifiedValues.ReadOnly]
    def latestRestorableTime: Optional[TStamp]
    def multiAZ: Optional[Boolean]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def readReplicaSourceDBInstanceIdentifier: Optional[String]
    def readReplicaDBInstanceIdentifiers: Optional[List[String]]
    def readReplicaDBClusterIdentifiers: Optional[List[String]]
    def replicaMode: Optional[zio.aws.rds.model.ReplicaMode]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupMemberships
        : Optional[List[zio.aws.rds.model.OptionGroupMembership.ReadOnly]]
    def characterSetName: Optional[String]
    def ncharCharacterSetName: Optional[String]
    def secondaryAvailabilityZone: Optional[String]
    def publiclyAccessible: Optional[Boolean]
    def statusInfos
        : Optional[List[zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly]]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def dbInstancePort: Optional[Integer]
    def dbClusterIdentifier: Optional[String]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbiResourceId: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def domainMemberships
        : Optional[List[zio.aws.rds.model.DomainMembership.ReadOnly]]
    def copyTagsToSnapshot: Optional[Boolean]
    def monitoringInterval: Optional[IntegerOptional]
    def enhancedMonitoringResourceArn: Optional[String]
    def monitoringRoleArn: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def dbInstanceArn: Optional[String]
    def timezone: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def performanceInsightsEnabled: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def enabledCloudwatchLogsExports: Optional[List[String]]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def deletionProtection: Optional[Boolean]
    def associatedRoles
        : Optional[List[zio.aws.rds.model.DBInstanceRole.ReadOnly]]
    def listenerEndpoint: Optional[zio.aws.rds.model.Endpoint.ReadOnly]
    def maxAllocatedStorage: Optional[IntegerOptional]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbInstanceAutomatedBackupsReplications: Optional[
      List[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly]
    ]
    def customerOwnedIpEnabled: Optional[BooleanOptional]
    def awsBackupRecoveryPointArn: Optional[String]
    def activityStreamStatus: Optional[zio.aws.rds.model.ActivityStreamStatus]
    def activityStreamKmsKeyId: Optional[String]
    def activityStreamKinesisStreamName: Optional[String]
    def activityStreamMode: Optional[zio.aws.rds.model.ActivityStreamMode]
    def activityStreamEngineNativeAuditFieldsIncluded: Optional[BooleanOptional]
    def automationMode: Optional[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeTime: Optional[TStamp]
    def customIamInstanceProfile: Optional[String]
    def backupTarget: Optional[String]
    def networkType: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDbInstanceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getAutomaticRestartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("automaticRestartTime", automaticRestartTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEndpoint: ZIO[Any, AwsError, zio.aws.rds.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBParameterGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues
        : ZIO[Any, AwsError, zio.aws.rds.model.PendingModifiedValues.ReadOnly] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getReadReplicaSourceDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "readReplicaSourceDBInstanceIdentifier",
        readReplicaSourceDBInstanceIdentifier
      )
    def getReadReplicaDBInstanceIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBInstanceIdentifiers",
        readReplicaDBInstanceIdentifiers
      )
    def getReadReplicaDBClusterIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBClusterIdentifiers",
        readReplicaDBClusterIdentifiers
      )
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupMemberships",
      optionGroupMemberships
    )
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getNcharCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ncharCharacterSetName", ncharCharacterSetName)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getDbInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstancePort", dbInstancePort)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getEnhancedMonitoringResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "enhancedMonitoringResourceArn",
        enhancedMonitoringResourceArn
      )
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBInstanceRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getListenerEndpoint
        : ZIO[Any, AwsError, zio.aws.rds.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("listenerEndpoint", listenerEndpoint)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getDbInstanceAutomatedBackupsReplications: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackupsReplications",
      dbInstanceAutomatedBackupsReplications
    )
    def getCustomerOwnedIpEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "customerOwnedIpEnabled",
        customerOwnedIpEnabled
      )
    def getAwsBackupRecoveryPointArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArn)
    def getActivityStreamStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getActivityStreamKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("activityStreamKmsKeyId", activityStreamKmsKeyId)
    def getActivityStreamKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "activityStreamKinesisStreamName",
        activityStreamKinesisStreamName
      )
    def getActivityStreamMode
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("activityStreamMode", activityStreamMode)
    def getActivityStreamEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "activityStreamEngineNativeAuditFieldsIncluded",
      activityStreamEngineNativeAuditFieldsIncluded
    )
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "resumeFullAutomationModeTime",
        resumeFullAutomationModeTime
      )
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstance
  ) extends zio.aws.rds.model.DBInstance.ReadOnly {
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val dbInstanceStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceStatus())
      .map(value => value: String)
    override val automaticRestartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticRestartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val endpoint: Optional[zio.aws.rds.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.rds.model.Endpoint.wrap(value))
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val dbSecurityGroups
        : Optional[List[zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBSecurityGroupMembership.wrap(item)
          }.toList
        )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val dbParameterGroups
        : Optional[List[zio.aws.rds.model.DBParameterGroupStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBParameterGroupStatus.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dbSubnetGroup
        : Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.rds.model.DBSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues
        : Optional[zio.aws.rds.model.PendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value => zio.aws.rds.model.PendingModifiedValues.wrap(value))
    override val latestRestorableTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val readReplicaSourceDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaSourceDBInstanceIdentifier())
        .map(value => value: String)
    override val readReplicaDBInstanceIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaDBInstanceIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val readReplicaDBClusterIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaDBClusterIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val replicaMode: Optional[zio.aws.rds.model.ReplicaMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupMemberships
        : Optional[List[zio.aws.rds.model.OptionGroupMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroupMembership.wrap(item)
          }.toList
        )
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val ncharCharacterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ncharCharacterSetName())
      .map(value => value: String)
    override val secondaryAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAvailabilityZone())
        .map(value => value: String)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val statusInfos
        : Optional[List[zio.aws.rds.model.DBInstanceStatusInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBInstanceStatusInfo.wrap(item)
          }.toList
        )
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val dbInstancePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstancePort())
      .map(value => value: Integer)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val domainMemberships
        : Optional[List[zio.aws.rds.model.DomainMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DomainMembership.wrap(item)
          }.toList
        )
    override val copyTagsToSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToSnapshot())
      .map(value => value: Boolean)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val enhancedMonitoringResourceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoringResourceArn())
        .map(value => value: String)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val dbInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceArn())
      .map(value => value: String)
    override val timezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val performanceInsightsEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsEnabled())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val enabledCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val deletionProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionProtection())
      .map(value => value: Boolean)
    override val associatedRoles
        : Optional[List[zio.aws.rds.model.DBInstanceRole.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedRoles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBInstanceRole.wrap(item)
          }.toList
        )
    override val listenerEndpoint
        : Optional[zio.aws.rds.model.Endpoint.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerEndpoint())
      .map(value => zio.aws.rds.model.Endpoint.wrap(value))
    override val maxAllocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllocatedStorage())
        .map(value => value: IntegerOptional)
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbInstanceAutomatedBackupsReplications: Optional[
      List[zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceAutomatedBackupsReplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBInstanceAutomatedBackupsReplication.wrap(item)
        }.toList
      )
    override val customerOwnedIpEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOwnedIpEnabled())
        .map(value => value: BooleanOptional)
    override val awsBackupRecoveryPointArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsBackupRecoveryPointArn())
        .map(value => value: String)
    override val activityStreamStatus
        : Optional[zio.aws.rds.model.ActivityStreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamStatus())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val activityStreamKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamKmsKeyId())
        .map(value => value: String)
    override val activityStreamKinesisStreamName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamKinesisStreamName())
        .map(value => value: String)
    override val activityStreamMode
        : Optional[zio.aws.rds.model.ActivityStreamMode] = zio.aws.core.internal
      .optionalFromNullable(impl.activityStreamMode())
      .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val activityStreamEngineNativeAuditFieldsIncluded
        : Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(
        impl.activityStreamEngineNativeAuditFieldsIncluded()
      )
      .map(value => value: BooleanOptional)
    override val automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationMode())
        .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resumeFullAutomationModeTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val customIamInstanceProfile: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customIamInstanceProfile())
        .map(value => value: String)
    override val backupTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupTarget())
      .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstance
  ): zio.aws.rds.model.DBInstance.ReadOnly = new Wrapper(impl)
}
