package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDbSecurityGroupResponse(
    dbSecurityGroup: Optional[zio.aws.rds.model.DBSecurityGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse = {
    import CreateDbSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse
      .builder()
      .optionallyWith(dbSecurityGroup.map(value => value.buildAwsValue()))(
        _.dbSecurityGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly =
    zio.aws.rds.model.CreateDbSecurityGroupResponse.wrap(buildAwsValue())
}
object CreateDbSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSecurityGroupResponse =
      zio.aws.rds.model.CreateDbSecurityGroupResponse(
        dbSecurityGroup.map(value => value.asEditable)
      )
    def dbSecurityGroup: Optional[zio.aws.rds.model.DBSecurityGroup.ReadOnly]
    def getDbSecurityGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSecurityGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSecurityGroup", dbSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse
  ) extends zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly {
    override val dbSecurityGroup
        : Optional[zio.aws.rds.model.DBSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroup())
        .map(value => zio.aws.rds.model.DBSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse
  ): zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
