package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDbClusterEndpointRequest(
    dbClusterIdentifier: String,
    dbClusterEndpointIdentifier: String,
    endpointType: String,
    staticMembers: Optional[Iterable[String]] = Optional.Absent,
    excludedMembers: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest = {
    import CreateDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .dbClusterEndpointIdentifier(
        dbClusterEndpointIdentifier: java.lang.String
      )
      .endpointType(endpointType: java.lang.String)
      .optionallyWith(
        staticMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.staticMembers)
      .optionallyWith(
        excludedMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludedMembers)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbClusterEndpointRequest.ReadOnly =
    zio.aws.rds.model.CreateDbClusterEndpointRequest.wrap(buildAwsValue())
}
object CreateDbClusterEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterEndpointRequest =
      zio.aws.rds.model.CreateDbClusterEndpointRequest(
        dbClusterIdentifier,
        dbClusterEndpointIdentifier,
        endpointType,
        staticMembers.map(value => value),
        excludedMembers.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterIdentifier: String
    def dbClusterEndpointIdentifier: String
    def endpointType: String
    def staticMembers: Optional[List[String]]
    def excludedMembers: Optional[List[String]]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterEndpointIdentifier)
    def getEndpointType: ZIO[Any, Nothing, String] = ZIO.succeed(endpointType)
    def getStaticMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("staticMembers", staticMembers)
    def getExcludedMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("excludedMembers", excludedMembers)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest
  ) extends zio.aws.rds.model.CreateDbClusterEndpointRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterEndpointIdentifier: String =
      impl.dbClusterEndpointIdentifier(): String
    override val endpointType: String = impl.endpointType(): String
    override val staticMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.staticMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val excludedMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludedMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest
  ): zio.aws.rds.model.CreateDbClusterEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
