package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudwatchLogsExportConfiguration(
    enableLogTypes: Optional[Iterable[String]] = Optional.Absent,
    disableLogTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration = {
    import CloudwatchLogsExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration
      .builder()
      .optionallyWith(
        enableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableLogTypes)
      .optionallyWith(
        disableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.disableLogTypes)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly =
    zio.aws.rds.model.CloudwatchLogsExportConfiguration.wrap(buildAwsValue())
}
object CloudwatchLogsExportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CloudwatchLogsExportConfiguration =
      zio.aws.rds.model.CloudwatchLogsExportConfiguration(
        enableLogTypes.map(value => value),
        disableLogTypes.map(value => value)
      )
    def enableLogTypes: Optional[List[String]]
    def disableLogTypes: Optional[List[String]]
    def getEnableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("enableLogTypes", enableLogTypes)
    def getDisableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("disableLogTypes", disableLogTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration
  ) extends zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly {
    override val enableLogTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.enableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val disableLogTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.disableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration
  ): zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
