package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait WriteForwardingStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.WriteForwardingStatus
}
object WriteForwardingStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.WriteForwardingStatus
  ): zio.aws.rds.model.WriteForwardingStatus = value match {
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.ENABLING =>
      val r = enabling
      r
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.DISABLING =>
      val r = disabling
      r
    case software.amazon.awssdk.services.rds.model.WriteForwardingStatus.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.ENABLED
  }
  case object disabled extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.DISABLED
  }
  case object enabling extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.ENABLING
  }
  case object disabling extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.DISABLING
  }
  case object unknown extends zio.aws.rds.model.WriteForwardingStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.WriteForwardingStatus =
      software.amazon.awssdk.services.rds.model.WriteForwardingStatus.UNKNOWN
  }
}
