package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyCertificatesResponse(
    certificate: Optional[zio.aws.rds.model.Certificate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse = {
    import ModifyCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly =
    zio.aws.rds.model.ModifyCertificatesResponse.wrap(buildAwsValue())
}
object ModifyCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCertificatesResponse =
      zio.aws.rds.model
        .ModifyCertificatesResponse(certificate.map(value => value.asEditable))
    def certificate: Optional[zio.aws.rds.model.Certificate.ReadOnly]
    def getCertificate
        : ZIO[Any, AwsError, zio.aws.rds.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse
  ) extends zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly {
    override val certificate: Optional[zio.aws.rds.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.rds.model.Certificate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse
  ): zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly = new Wrapper(impl)
}
