package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDbProxyEndpointResponse(
    dbProxyEndpoint: Optional[zio.aws.rds.model.DBProxyEndpoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse = {
    import DeleteDbProxyEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse
      .builder()
      .optionallyWith(dbProxyEndpoint.map(value => value.buildAwsValue()))(
        _.dbProxyEndpoint
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbProxyEndpointResponse.wrap(buildAwsValue())
}
object DeleteDbProxyEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbProxyEndpointResponse =
      zio.aws.rds.model.DeleteDbProxyEndpointResponse(
        dbProxyEndpoint.map(value => value.asEditable)
      )
    def dbProxyEndpoint: Optional[zio.aws.rds.model.DBProxyEndpoint.ReadOnly]
    def getDbProxyEndpoint
        : ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("dbProxyEndpoint", dbProxyEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse
  ) extends zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly {
    override val dbProxyEndpoint
        : Optional[zio.aws.rds.model.DBProxyEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbProxyEndpoint())
        .map(value => zio.aws.rds.model.DBProxyEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse
  ): zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
