package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDbClusterRequest(
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    engine: String,
    engineVersion: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    replicationSourceIdentifier: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    preSignedUrl: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    scalingConfiguration: Optional[zio.aws.rds.model.ScalingConfiguration] =
      Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    globalClusterIdentifier: Optional[String] = Optional.Absent,
    enableHttpEndpoint: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    enableGlobalWriteForwarding: Optional[BooleanOptional] = Optional.Absent,
    dbClusterInstanceClass: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbClusterRequest = {
    import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        enableHttpEndpoint.map(value => value: java.lang.Boolean)
      )(_.enableHttpEndpoint)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        enableGlobalWriteForwarding.map(value => value: java.lang.Boolean)
      )(_.enableGlobalWriteForwarding)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbClusterRequest.ReadOnly =
    zio.aws.rds.model.CreateDbClusterRequest.wrap(buildAwsValue())
}
object CreateDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbClusterRequest =
      zio.aws.rds.model.CreateDbClusterRequest(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        characterSetName.map(value => value),
        databaseName.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        replicationSourceIdentifier.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        engineMode.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        deletionProtection.map(value => value),
        globalClusterIdentifier.map(value => value),
        enableHttpEndpoint.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        enableGlobalWriteForwarding.map(value => value),
        dbClusterInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        publiclyAccessible.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        serverlessV2ScalingConfiguration.map(value => value.asEditable)
      )
    def availabilityZones: Optional[List[String]]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def characterSetName: Optional[String]
    def databaseName: Optional[String]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def dbSubnetGroupName: Optional[String]
    def engine: String
    def engineVersion: Optional[String]
    def port: Optional[IntegerOptional]
    def masterUsername: Optional[String]
    def masterUserPassword: Optional[String]
    def optionGroupName: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def replicationSourceIdentifier: Optional[String]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageEncrypted: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def preSignedUrl: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def backtrackWindow: Optional[LongOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def engineMode: Optional[String]
    def scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def deletionProtection: Optional[BooleanOptional]
    def globalClusterIdentifier: Optional[String]
    def enableHttpEndpoint: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def enableGlobalWriteForwarding: Optional[BooleanOptional]
    def dbClusterInstanceClass: Optional[String]
    def allocatedStorage: Optional[IntegerOptional]
    def storageType: Optional[String]
    def iops: Optional[IntegerOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def monitoringInterval: Optional[IntegerOptional]
    def monitoringRoleArn: Optional[String]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def serverlessV2ScalingConfiguration
        : Optional[zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getEnableHttpEndpoint: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpoint)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getEnableGlobalWriteForwarding: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableGlobalWriteForwarding",
        enableGlobalWriteForwarding
      )
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ) extends zio.aws.rds.model.CreateDbClusterRequest.ReadOnly {
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val replicationSourceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSourceIdentifier())
        .map(value => value: String)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val preSignedUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignedUrl())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfiguration())
        .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val globalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value => value: String)
    override val enableHttpEndpoint: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableHttpEndpoint())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val enableGlobalWriteForwarding: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableGlobalWriteForwarding())
        .map(value => value: BooleanOptional)
    override val dbClusterInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterInstanceClass())
        .map(value => value: String)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.rds.model.ServerlessV2ScalingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest
  ): zio.aws.rds.model.CreateDbClusterRequest.ReadOnly = new Wrapper(impl)
}
