package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, TStamp}
import scala.jdk.CollectionConverters.*
final case class BacktrackDbClusterRequest(
    dbClusterIdentifier: String,
    backtrackTo: TStamp,
    force: Optional[BooleanOptional] = Optional.Absent,
    useEarliestTimeOnPointInTimeUnavailable: Optional[BooleanOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest = {
    import BacktrackDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .backtrackTo(TStamp.unwrap(backtrackTo): Instant)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(
        useEarliestTimeOnPointInTimeUnavailable.map(value =>
          value: java.lang.Boolean
        )
      )(_.useEarliestTimeOnPointInTimeUnavailable)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.BacktrackDbClusterRequest.ReadOnly =
    zio.aws.rds.model.BacktrackDbClusterRequest.wrap(buildAwsValue())
}
object BacktrackDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.BacktrackDbClusterRequest =
      zio.aws.rds.model.BacktrackDbClusterRequest(
        dbClusterIdentifier,
        backtrackTo,
        force.map(value => value),
        useEarliestTimeOnPointInTimeUnavailable.map(value => value)
      )
    def dbClusterIdentifier: String
    def backtrackTo: TStamp
    def force: Optional[BooleanOptional]
    def useEarliestTimeOnPointInTimeUnavailable: Optional[BooleanOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getBacktrackTo: ZIO[Any, Nothing, TStamp] = ZIO.succeed(backtrackTo)
    def getForce: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("force", force)
    def getUseEarliestTimeOnPointInTimeUnavailable
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "useEarliestTimeOnPointInTimeUnavailable",
      useEarliestTimeOnPointInTimeUnavailable
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest
  ) extends zio.aws.rds.model.BacktrackDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val backtrackTo: TStamp =
      zio.aws.rds.model.primitives.TStamp(impl.backtrackTo())
    override val force: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: BooleanOptional)
    override val useEarliestTimeOnPointInTimeUnavailable
        : Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.useEarliestTimeOnPointInTimeUnavailable())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest
  ): zio.aws.rds.model.BacktrackDbClusterRequest.ReadOnly = new Wrapper(impl)
}
