package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplyPendingMaintenanceActionResponse(
    resourcePendingMaintenanceActions: Optional[
      zio.aws.rds.model.ResourcePendingMaintenanceActions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse = {
    import ApplyPendingMaintenanceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse
      .builder()
      .optionallyWith(
        resourcePendingMaintenanceActions.map(value => value.buildAwsValue())
      )(_.resourcePendingMaintenanceActions)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    zio.aws.rds.model.ApplyPendingMaintenanceActionResponse
      .wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ApplyPendingMaintenanceActionResponse =
      zio.aws.rds.model.ApplyPendingMaintenanceActionResponse(
        resourcePendingMaintenanceActions.map(value => value.asEditable)
      )
    def resourcePendingMaintenanceActions
        : Optional[zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly]
    def getResourcePendingMaintenanceActions: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourcePendingMaintenanceActions",
      resourcePendingMaintenanceActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse
  ) extends zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly {
    override val resourcePendingMaintenanceActions: Optional[
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcePendingMaintenanceActions())
      .map(value =>
        zio.aws.rds.model.ResourcePendingMaintenanceActions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse
  ): zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    new Wrapper(impl)
}
