package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddRoleToDbClusterRequest(
    dbClusterIdentifier: String,
    roleArn: String,
    featureName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest = {
    import AddRoleToDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.AddRoleToDbClusterRequest.ReadOnly =
    zio.aws.rds.model.AddRoleToDbClusterRequest.wrap(buildAwsValue())
}
object AddRoleToDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.AddRoleToDbClusterRequest =
      zio.aws.rds.model.AddRoleToDbClusterRequest(
        dbClusterIdentifier,
        roleArn,
        featureName.map(value => value)
      )
    def dbClusterIdentifier: String
    def roleArn: String
    def featureName: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest
  ) extends zio.aws.rds.model.AddRoleToDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val roleArn: String = impl.roleArn(): String
    override val featureName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest
  ): zio.aws.rds.model.AddRoleToDbClusterRequest.ReadOnly = new Wrapper(impl)
}
