package zio.aws.rds.model
import zio.aws.rds.model.primitives.StringSensitive
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpnDetails(
    vpnId: Optional[String] = Optional.Absent,
    vpnTunnelOriginatorIP: Optional[String] = Optional.Absent,
    vpnGatewayIp: Optional[String] = Optional.Absent,
    vpnPSK: Optional[StringSensitive] = Optional.Absent,
    vpnName: Optional[String] = Optional.Absent,
    vpnState: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.VpnDetails = {
    import VpnDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.VpnDetails
      .builder()
      .optionallyWith(vpnId.map(value => value: java.lang.String))(_.vpnId)
      .optionallyWith(
        vpnTunnelOriginatorIP.map(value => value: java.lang.String)
      )(_.vpnTunnelOriginatorIP)
      .optionallyWith(vpnGatewayIp.map(value => value: java.lang.String))(
        _.vpnGatewayIp
      )
      .optionallyWith(
        vpnPSK.map(value => StringSensitive.unwrap(value): java.lang.String)
      )(_.vpnPSK)
      .optionallyWith(vpnName.map(value => value: java.lang.String))(_.vpnName)
      .optionallyWith(vpnState.map(value => value: java.lang.String))(
        _.vpnState
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.VpnDetails.ReadOnly =
    zio.aws.rds.model.VpnDetails.wrap(buildAwsValue())
}
object VpnDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.VpnDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.VpnDetails = zio.aws.rds.model.VpnDetails(
      vpnId.map(value => value),
      vpnTunnelOriginatorIP.map(value => value),
      vpnGatewayIp.map(value => value),
      vpnPSK.map(value => value),
      vpnName.map(value => value),
      vpnState.map(value => value)
    )
    def vpnId: Optional[String]
    def vpnTunnelOriginatorIP: Optional[String]
    def vpnGatewayIp: Optional[String]
    def vpnPSK: Optional[StringSensitive]
    def vpnName: Optional[String]
    def vpnState: Optional[String]
    def getVpnId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnId", vpnId)
    def getVpnTunnelOriginatorIP: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnTunnelOriginatorIP", vpnTunnelOriginatorIP)
    def getVpnGatewayIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayIp", vpnGatewayIp)
    def getVpnPSK: ZIO[Any, AwsError, StringSensitive] =
      AwsError.unwrapOptionField("vpnPSK", vpnPSK)
    def getVpnName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnName", vpnName)
    def getVpnState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnState", vpnState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.VpnDetails
  ) extends zio.aws.rds.model.VpnDetails.ReadOnly {
    override val vpnId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnId())
      .map(value => value: String)
    override val vpnTunnelOriginatorIP: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnTunnelOriginatorIP())
      .map(value => value: String)
    override val vpnGatewayIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayIp())
      .map(value => value: String)
    override val vpnPSK: Optional[StringSensitive] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnPSK())
      .map(value => zio.aws.rds.model.primitives.StringSensitive(value))
    override val vpnName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnName())
      .map(value => value: String)
    override val vpnState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnState())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.VpnDetails
  ): zio.aws.rds.model.VpnDetails.ReadOnly = new Wrapper(impl)
}
