package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpgradeTarget(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    autoUpgrade: Optional[Boolean] = Optional.Absent,
    isMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    supportedEngineModes: Optional[Iterable[String]] = Optional.Absent,
    supportsParallelQuery: Optional[BooleanOptional] = Optional.Absent,
    supportsGlobalDatabases: Optional[BooleanOptional] = Optional.Absent,
    supportsBabelfish: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.UpgradeTarget = {
    import UpgradeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.UpgradeTarget
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoUpgrade.map(value => value: java.lang.Boolean))(
        _.autoUpgrade
      )
      .optionallyWith(
        isMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.isMajorVersionUpgrade)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .optionallyWith(
        supportsParallelQuery.map(value => value: java.lang.Boolean)
      )(_.supportsParallelQuery)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .optionallyWith(supportsBabelfish.map(value => value: java.lang.Boolean))(
        _.supportsBabelfish
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.UpgradeTarget.ReadOnly =
    zio.aws.rds.model.UpgradeTarget.wrap(buildAwsValue())
}
object UpgradeTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.UpgradeTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.UpgradeTarget =
      zio.aws.rds.model.UpgradeTarget(
        engine.map(value => value),
        engineVersion.map(value => value),
        description.map(value => value),
        autoUpgrade.map(value => value),
        isMajorVersionUpgrade.map(value => value),
        supportedEngineModes.map(value => value),
        supportsParallelQuery.map(value => value),
        supportsGlobalDatabases.map(value => value),
        supportsBabelfish.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def description: Optional[String]
    def autoUpgrade: Optional[Boolean]
    def isMajorVersionUpgrade: Optional[Boolean]
    def supportedEngineModes: Optional[List[String]]
    def supportsParallelQuery: Optional[BooleanOptional]
    def supportsGlobalDatabases: Optional[BooleanOptional]
    def supportsBabelfish: Optional[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpgrade", autoUpgrade)
    def getIsMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMajorVersionUpgrade", isMajorVersionUpgrade)
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
    def getSupportsParallelQuery: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("supportsParallelQuery", supportsParallelQuery)
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsGlobalDatabases",
        supportsGlobalDatabases
      )
    def getSupportsBabelfish: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("supportsBabelfish", supportsBabelfish)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.UpgradeTarget
  ) extends zio.aws.rds.model.UpgradeTarget.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val autoUpgrade: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpgrade())
      .map(value => value: Boolean)
    override val isMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val supportedEngineModes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedEngineModes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportsParallelQuery: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsParallelQuery())
        .map(value => value: BooleanOptional)
    override val supportsGlobalDatabases: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsGlobalDatabases())
        .map(value => value: BooleanOptional)
    override val supportsBabelfish: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsBabelfish())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.UpgradeTarget
  ): zio.aws.rds.model.UpgradeTarget.ReadOnly = new Wrapper(impl)
}
