package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Timezone(timezoneName: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Timezone = {
    import Timezone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Timezone
      .builder()
      .optionallyWith(timezoneName.map(value => value: java.lang.String))(
        _.timezoneName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Timezone.ReadOnly =
    zio.aws.rds.model.Timezone.wrap(buildAwsValue())
}
object Timezone {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Timezone] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Timezone =
      zio.aws.rds.model.Timezone(timezoneName.map(value => value))
    def timezoneName: Optional[String]
    def getTimezoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezoneName", timezoneName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Timezone
  ) extends zio.aws.rds.model.Timezone.ReadOnly {
    override val timezoneName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezoneName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Timezone
  ): zio.aws.rds.model.Timezone.ReadOnly = new Wrapper(impl)
}
