package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RestoreDbClusterFromSnapshotRequest(
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    dbClusterIdentifier: String,
    snapshotIdentifier: String,
    engine: String,
    engineVersion: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    scalingConfiguration: Optional[zio.aws.rds.model.ScalingConfiguration] =
      Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    dbClusterInstanceClass: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest = {
    import RestoreDbClusterFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest =
      zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest(
        availabilityZones.map(value => value),
        dbClusterIdentifier,
        snapshotIdentifier,
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        databaseName.map(value => value),
        optionGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        engineMode.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        dbClusterParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        dbClusterInstanceClass.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        publiclyAccessible.map(value => value)
      )
    def availabilityZones: Optional[List[String]]
    def dbClusterIdentifier: String
    def snapshotIdentifier: String
    def engine: String
    def engineVersion: Optional[String]
    def port: Optional[IntegerOptional]
    def dbSubnetGroupName: Optional[String]
    def databaseName: Optional[String]
    def optionGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def backtrackWindow: Optional[LongOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def engineMode: Optional[String]
    def scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def dbClusterParameterGroupName: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def dbClusterInstanceClass: Optional[String]
    def storageType: Optional[String]
    def iops: Optional[IntegerOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ) extends zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly {
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val engine: String = impl.engine(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfiguration())
        .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val dbClusterInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterInstanceClass())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest
  ): zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
