package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemoveFromGlobalClusterRequest(
    globalClusterIdentifier: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest = {
    import RemoveFromGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.RemoveFromGlobalClusterRequest.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RemoveFromGlobalClusterRequest =
      zio.aws.rds.model.RemoveFromGlobalClusterRequest(
        globalClusterIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value)
      )
    def globalClusterIdentifier: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ) extends zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest
  ): zio.aws.rds.model.RemoveFromGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
