package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PromoteReadReplicaResponse(
    dbInstance: Optional[zio.aws.rds.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse = {
    import PromoteReadReplicaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly =
    zio.aws.rds.model.PromoteReadReplicaResponse.wrap(buildAwsValue())
}
object PromoteReadReplicaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PromoteReadReplicaResponse =
      zio.aws.rds.model
        .PromoteReadReplicaResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse
  ) extends zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse
  ): zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly = new Wrapper(impl)
}
