package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PromoteReadReplicaRequest(
    dbInstanceIdentifier: String,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest = {
    import PromoteReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly =
    zio.aws.rds.model.PromoteReadReplicaRequest.wrap(buildAwsValue())
}
object PromoteReadReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PromoteReadReplicaRequest =
      zio.aws.rds.model.PromoteReadReplicaRequest(
        dbInstanceIdentifier,
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value)
      )
    def dbInstanceIdentifier: String
    def backupRetentionPeriod: Optional[IntegerOptional]
    def preferredBackupWindow: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ) extends zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest
  ): zio.aws.rds.model.PromoteReadReplicaRequest.ReadOnly = new Wrapper(impl)
}
