package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PendingCloudwatchLogsExports(
    logTypesToEnable: Optional[Iterable[String]] = Optional.Absent,
    logTypesToDisable: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports = {
    import PendingCloudwatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
      .builder()
      .optionallyWith(
        logTypesToEnable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToEnable)
      .optionallyWith(
        logTypesToDisable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToDisable)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly =
    zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(buildAwsValue())
}
object PendingCloudwatchLogsExports {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingCloudwatchLogsExports =
      zio.aws.rds.model.PendingCloudwatchLogsExports(
        logTypesToEnable.map(value => value),
        logTypesToDisable.map(value => value)
      )
    def logTypesToEnable: Optional[List[String]]
    def logTypesToDisable: Optional[List[String]]
    def getLogTypesToEnable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnable)
    def getLogTypesToDisable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ) extends zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly {
    override val logTypesToEnable: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToEnable())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val logTypesToDisable: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToDisable())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingCloudwatchLogsExports
  ): zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly = new Wrapper(impl)
}
