package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OptionGroupOptionSetting(
    settingName: Optional[String] = Optional.Absent,
    settingDescription: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    applyType: Optional[String] = Optional.Absent,
    allowedValues: Optional[String] = Optional.Absent,
    isModifiable: Optional[Boolean] = Optional.Absent,
    isRequired: Optional[Boolean] = Optional.Absent,
    minimumEngineVersionPerAllowedValue: Optional[
      Iterable[zio.aws.rds.model.MinimumEngineVersionPerAllowedValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting = {
    import OptionGroupOptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
      .builder()
      .optionallyWith(settingName.map(value => value: java.lang.String))(
        _.settingName
      )
      .optionallyWith(settingDescription.map(value => value: java.lang.String))(
        _.settingDescription
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .optionallyWith(
        minimumEngineVersionPerAllowedValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.minimumEngineVersionPerAllowedValue)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly =
    zio.aws.rds.model.OptionGroupOptionSetting.wrap(buildAwsValue())
}
object OptionGroupOptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupOptionSetting =
      zio.aws.rds.model.OptionGroupOptionSetting(
        settingName.map(value => value),
        settingDescription.map(value => value),
        defaultValue.map(value => value),
        applyType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        isRequired.map(value => value),
        minimumEngineVersionPerAllowedValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def settingName: Optional[String]
    def settingDescription: Optional[String]
    def defaultValue: Optional[String]
    def applyType: Optional[String]
    def allowedValues: Optional[String]
    def isModifiable: Optional[Boolean]
    def isRequired: Optional[Boolean]
    def minimumEngineVersionPerAllowedValue: Optional[
      List[zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly]
    ]
    def getSettingName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("settingName", settingName)
    def getSettingDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("settingDescription", settingDescription)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getMinimumEngineVersionPerAllowedValue: ZIO[Any, AwsError, List[
      zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "minimumEngineVersionPerAllowedValue",
      minimumEngineVersionPerAllowedValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ) extends zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly {
    override val settingName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.settingName())
      .map(value => value: String)
    override val settingDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.settingDescription())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val applyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applyType())
      .map(value => value: String)
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
    override val isModifiable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isModifiable())
      .map(value => value: Boolean)
    override val isRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequired())
      .map(value => value: Boolean)
    override val minimumEngineVersionPerAllowedValue: Optional[
      List[zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersionPerAllowedValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.MinimumEngineVersionPerAllowedValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting
  ): zio.aws.rds.model.OptionGroupOptionSetting.ReadOnly = new Wrapper(impl)
}
