package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OptionGroupMembership(
    optionGroupName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionGroupMembership = {
    import OptionGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroupMembership
      .builder()
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroupMembership.ReadOnly =
    zio.aws.rds.model.OptionGroupMembership.wrap(buildAwsValue())
}
object OptionGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroupMembership =
      zio.aws.rds.model.OptionGroupMembership(
        optionGroupName.map(value => value),
        status.map(value => value)
      )
    def optionGroupName: Optional[String]
    def status: Optional[String]
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ) extends zio.aws.rds.model.OptionGroupMembership.ReadOnly {
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroupMembership
  ): zio.aws.rds.model.OptionGroupMembership.ReadOnly = new Wrapper(impl)
}
