package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyGlobalClusterResponse(
    globalCluster: Optional[zio.aws.rds.model.GlobalCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse = {
    import ModifyGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly =
    zio.aws.rds.model.ModifyGlobalClusterResponse.wrap(buildAwsValue())
}
object ModifyGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyGlobalClusterResponse =
      zio.aws.rds.model.ModifyGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.rds.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse
  ) extends zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.rds.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.rds.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse
  ): zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly = new Wrapper(impl)
}
