package zio.aws.rds.model
import zio.aws.rds.model.primitives.DBProxyEndpointName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbProxyEndpointRequest(
    dbProxyEndpointName: DBProxyEndpointName,
    newDBProxyEndpointName: Optional[DBProxyEndpointName] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest = {
    import ModifyDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest
      .builder()
      .dbProxyEndpointName(
        DBProxyEndpointName.unwrap(dbProxyEndpointName): java.lang.String
      )
      .optionallyWith(
        newDBProxyEndpointName.map(value =>
          DBProxyEndpointName.unwrap(value): java.lang.String
        )
      )(_.newDBProxyEndpointName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbProxyEndpointRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbProxyEndpointRequest.wrap(buildAwsValue())
}
object ModifyDbProxyEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbProxyEndpointRequest =
      zio.aws.rds.model.ModifyDbProxyEndpointRequest(
        dbProxyEndpointName,
        newDBProxyEndpointName.map(value => value),
        vpcSecurityGroupIds.map(value => value)
      )
    def dbProxyEndpointName: DBProxyEndpointName
    def newDBProxyEndpointName: Optional[DBProxyEndpointName]
    def vpcSecurityGroupIds: Optional[List[String]]
    def getDbProxyEndpointName: ZIO[Any, Nothing, DBProxyEndpointName] =
      ZIO.succeed(dbProxyEndpointName)
    def getNewDBProxyEndpointName: ZIO[Any, AwsError, DBProxyEndpointName] =
      AwsError.unwrapOptionField(
        "newDBProxyEndpointName",
        newDBProxyEndpointName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest
  ) extends zio.aws.rds.model.ModifyDbProxyEndpointRequest.ReadOnly {
    override val dbProxyEndpointName: DBProxyEndpointName =
      zio.aws.rds.model.primitives
        .DBProxyEndpointName(impl.dbProxyEndpointName())
    override val newDBProxyEndpointName: Optional[DBProxyEndpointName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBProxyEndpointName())
        .map(value => zio.aws.rds.model.primitives.DBProxyEndpointName(value))
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest
  ): zio.aws.rds.model.ModifyDbProxyEndpointRequest.ReadOnly = new Wrapper(impl)
}
