package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyDbClusterRequest(
    dbClusterIdentifier: String,
    newDBClusterIdentifier: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    cloudwatchLogsExportConfiguration: Optional[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration
    ] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    dbInstanceParameterGroupName: Optional[String] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    scalingConfiguration: Optional[zio.aws.rds.model.ScalingConfiguration] =
      Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    enableHttpEndpoint: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    enableGlobalWriteForwarding: Optional[BooleanOptional] = Optional.Absent,
    dbClusterInstanceClass: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        newDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.newDBClusterIdentifier)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        dbInstanceParameterGroupName.map(value => value: java.lang.String)
      )(_.dbInstanceParameterGroupName)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(
        _.scalingConfiguration
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        enableHttpEndpoint.map(value => value: java.lang.Boolean)
      )(_.enableHttpEndpoint)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        enableGlobalWriteForwarding.map(value => value: java.lang.Boolean)
      )(_.enableGlobalWriteForwarding)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterRequest =
      zio.aws.rds.model.ModifyDbClusterRequest(
        dbClusterIdentifier,
        newDBClusterIdentifier.map(value => value),
        applyImmediately.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        port.map(value => value),
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        backtrackWindow.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        dbInstanceParameterGroupName.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        scalingConfiguration.map(value => value.asEditable),
        deletionProtection.map(value => value),
        enableHttpEndpoint.map(value => value),
        copyTagsToSnapshot.map(value => value),
        enableGlobalWriteForwarding.map(value => value),
        dbClusterInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        storageType.map(value => value),
        iops.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value)
      )
    def dbClusterIdentifier: String
    def newDBClusterIdentifier: Optional[String]
    def applyImmediately: Optional[Boolean]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def port: Optional[IntegerOptional]
    def masterUserPassword: Optional[String]
    def optionGroupName: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def backtrackWindow: Optional[LongOptional]
    def cloudwatchLogsExportConfiguration
        : Optional[zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[Boolean]
    def dbInstanceParameterGroupName: Optional[String]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly]
    def deletionProtection: Optional[BooleanOptional]
    def enableHttpEndpoint: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def enableGlobalWriteForwarding: Optional[BooleanOptional]
    def dbClusterInstanceClass: Optional[String]
    def allocatedStorage: Optional[IntegerOptional]
    def storageType: Optional[String]
    def iops: Optional[IntegerOptional]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def monitoringInterval: Optional[IntegerOptional]
    def monitoringRoleArn: Optional[String]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getNewDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifier)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getDbInstanceParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceParameterGroupName",
        dbInstanceParameterGroupName
      )
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getScalingConfiguration
        : ZIO[Any, AwsError, zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfiguration", scalingConfiguration)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEnableHttpEndpoint: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpoint)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getEnableGlobalWriteForwarding: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableGlobalWriteForwarding",
        enableGlobalWriteForwarding
      )
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ) extends zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val newDBClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBClusterIdentifier())
        .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val cloudwatchLogsExportConfiguration: Optional[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.rds.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val dbInstanceParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceParameterGroupName())
        .map(value => value: String)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val scalingConfiguration
        : Optional[zio.aws.rds.model.ScalingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfiguration())
        .map(value => zio.aws.rds.model.ScalingConfiguration.wrap(value))
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val enableHttpEndpoint: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableHttpEndpoint())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val enableGlobalWriteForwarding: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableGlobalWriteForwarding())
        .map(value => value: BooleanOptional)
    override val dbClusterInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterInstanceClass())
        .map(value => value: String)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest
  ): zio.aws.rds.model.ModifyDbClusterRequest.ReadOnly = new Wrapper(impl)
}
