package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSourceRegionsResponse(
    marker: Optional[String] = Optional.Absent,
    sourceRegions: Optional[Iterable[zio.aws.rds.model.SourceRegion]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse = {
    import DescribeSourceRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        sourceRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceRegions)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeSourceRegionsResponse.wrap(buildAwsValue())
}
object DescribeSourceRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeSourceRegionsResponse =
      zio.aws.rds.model.DescribeSourceRegionsResponse(
        marker.map(value => value),
        sourceRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def sourceRegions: Optional[List[zio.aws.rds.model.SourceRegion.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSourceRegions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.SourceRegion.ReadOnly]] =
      AwsError.unwrapOptionField("sourceRegions", sourceRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse
  ) extends zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val sourceRegions
        : Optional[List[zio.aws.rds.model.SourceRegion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.SourceRegion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse
  ): zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
