package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOptionGroupOptionsResponse(
    optionGroupOptions: Optional[
      Iterable[zio.aws.rds.model.OptionGroupOption]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse = {
    import DescribeOptionGroupOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
      .builder()
      .optionallyWith(
        optionGroupOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupOptions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupOptionsResponse.wrap(buildAwsValue())
}
object DescribeOptionGroupOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupOptionsResponse =
      zio.aws.rds.model.DescribeOptionGroupOptionsResponse(
        optionGroupOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def optionGroupOptions
        : Optional[List[zio.aws.rds.model.OptionGroupOption.ReadOnly]]
    def marker: Optional[String]
    def getOptionGroupOptions: ZIO[Any, AwsError, List[
      zio.aws.rds.model.OptionGroupOption.ReadOnly
    ]] = AwsError.unwrapOptionField("optionGroupOptions", optionGroupOptions)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ) extends zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly {
    override val optionGroupOptions
        : Optional[List[zio.aws.rds.model.OptionGroupOption.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionGroupOption.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse
  ): zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
