package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeExportTasksResponse(
    marker: Optional[String] = Optional.Absent,
    exportTasks: Optional[Iterable[zio.aws.rds.model.ExportTask]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse = {
    import DescribeExportTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        exportTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportTasks)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly =
    zio.aws.rds.model.DescribeExportTasksResponse.wrap(buildAwsValue())
}
object DescribeExportTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeExportTasksResponse =
      zio.aws.rds.model.DescribeExportTasksResponse(
        marker.map(value => value),
        exportTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def exportTasks: Optional[List[zio.aws.rds.model.ExportTask.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getExportTasks
        : ZIO[Any, AwsError, List[zio.aws.rds.model.ExportTask.ReadOnly]] =
      AwsError.unwrapOptionField("exportTasks", exportTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse
  ) extends zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val exportTasks
        : Optional[List[zio.aws.rds.model.ExportTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ExportTask.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse
  ): zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly = new Wrapper(impl)
}
