package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEventCategoriesResponse(
    eventCategoriesMapList: Optional[
      Iterable[zio.aws.rds.model.EventCategoriesMap]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse = {
    import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse
      .builder()
      .optionallyWith(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventCategoriesMapList)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly =
    zio.aws.rds.model.DescribeEventCategoriesResponse.wrap(buildAwsValue())
}
object DescribeEventCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeEventCategoriesResponse =
      zio.aws.rds.model.DescribeEventCategoriesResponse(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventCategoriesMapList
        : Optional[List[zio.aws.rds.model.EventCategoriesMap.ReadOnly]]
    def getEventCategoriesMapList: ZIO[Any, AwsError, List[
      zio.aws.rds.model.EventCategoriesMap.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventCategoriesMapList",
      eventCategoriesMapList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse
  ) extends zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly {
    override val eventCategoriesMapList
        : Optional[List[zio.aws.rds.model.EventCategoriesMap.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesMapList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.EventCategoriesMap.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse
  ): zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly = new Wrapper(
    impl
  )
}
