package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDbLogFilesRequest(
    dbInstanceIdentifier: String,
    filenameContains: Optional[String] = Optional.Absent,
    fileLastWritten: Optional[Long] = Optional.Absent,
    fileSize: Optional[Long] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest = {
    import DescribeDbLogFilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(filenameContains.map(value => value: java.lang.String))(
        _.filenameContains
      )
      .optionallyWith(fileLastWritten.map(value => value: java.lang.Long))(
        _.fileLastWritten
      )
      .optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbLogFilesRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbLogFilesRequest.wrap(buildAwsValue())
}
object DescribeDbLogFilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbLogFilesRequest =
      zio.aws.rds.model.DescribeDbLogFilesRequest(
        dbInstanceIdentifier,
        filenameContains.map(value => value),
        fileLastWritten.map(value => value),
        fileSize.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbInstanceIdentifier: String
    def filenameContains: Optional[String]
    def fileLastWritten: Optional[Long]
    def fileSize: Optional[Long]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getFilenameContains: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filenameContains", filenameContains)
    def getFileLastWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileLastWritten", fileLastWritten)
    def getFileSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileSize", fileSize)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest
  ) extends zio.aws.rds.model.DescribeDbLogFilesRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val filenameContains: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filenameContains())
      .map(value => value: String)
    override val fileLastWritten: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileLastWritten())
      .map(value => value: Long)
    override val fileSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSize())
      .map(value => value: Long)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest
  ): zio.aws.rds.model.DescribeDbLogFilesRequest.ReadOnly = new Wrapper(impl)
}
