package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDbEngineVersionsRequest(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    defaultOnly: Optional[Boolean] = Optional.Absent,
    listSupportedCharacterSets: Optional[BooleanOptional] = Optional.Absent,
    listSupportedTimezones: Optional[BooleanOptional] = Optional.Absent,
    includeAll: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest = {
    import DescribeDbEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(
        _.defaultOnly
      )
      .optionallyWith(
        listSupportedCharacterSets.map(value => value: java.lang.Boolean)
      )(_.listSupportedCharacterSets)
      .optionallyWith(
        listSupportedTimezones.map(value => value: java.lang.Boolean)
      )(_.listSupportedTimezones)
      .optionallyWith(includeAll.map(value => value: java.lang.Boolean))(
        _.includeAll
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbEngineVersionsRequest.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbEngineVersionsRequest =
      zio.aws.rds.model.DescribeDbEngineVersionsRequest(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        defaultOnly.map(value => value),
        listSupportedCharacterSets.map(value => value),
        listSupportedTimezones.map(value => value),
        includeAll.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def defaultOnly: Optional[Boolean]
    def listSupportedCharacterSets: Optional[BooleanOptional]
    def listSupportedTimezones: Optional[BooleanOptional]
    def includeAll: Optional[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDefaultOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultOnly", defaultOnly)
    def getListSupportedCharacterSets: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedCharacterSets",
        listSupportedCharacterSets
      )
    def getListSupportedTimezones: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "listSupportedTimezones",
        listSupportedTimezones
      )
    def getIncludeAll: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeAll", includeAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ) extends zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val defaultOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultOnly())
      .map(value => value: Boolean)
    override val listSupportedCharacterSets: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listSupportedCharacterSets())
        .map(value => value: BooleanOptional)
    override val listSupportedTimezones: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listSupportedTimezones())
        .map(value => value: BooleanOptional)
    override val includeAll: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.includeAll())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest
  ): zio.aws.rds.model.DescribeDbEngineVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
