package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCustomAvailabilityZonesResponse(
    marker: Optional[String] = Optional.Absent,
    customAvailabilityZones: Optional[
      Iterable[zio.aws.rds.model.CustomAvailabilityZone]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse = {
    import DescribeCustomAvailabilityZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        customAvailabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAvailabilityZones)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly =
    zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse
      .wrap(buildAwsValue())
}
object DescribeCustomAvailabilityZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse =
      zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse(
        marker.map(value => value),
        customAvailabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def customAvailabilityZones
        : Optional[List[zio.aws.rds.model.CustomAvailabilityZone.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCustomAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.rds.model.CustomAvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customAvailabilityZones",
      customAvailabilityZones
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ) extends zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val customAvailabilityZones
        : Optional[List[zio.aws.rds.model.CustomAvailabilityZone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.CustomAvailabilityZone.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse
  ): zio.aws.rds.model.DescribeCustomAvailabilityZonesResponse.ReadOnly =
    new Wrapper(impl)
}
