package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeCustomAvailabilityZonesRequest(
    customAvailabilityZoneId: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest = {
    import DescribeCustomAvailabilityZonesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest
      .builder()
      .optionallyWith(
        customAvailabilityZoneId.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest.ReadOnly =
    zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest
      .wrap(buildAwsValue())
}
object DescribeCustomAvailabilityZonesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest =
      zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest(
        customAvailabilityZoneId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def customAvailabilityZoneId: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getCustomAvailabilityZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest
  ) extends zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest.ReadOnly {
    override val customAvailabilityZoneId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZoneId())
        .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest
  ): zio.aws.rds.model.DescribeCustomAvailabilityZonesRequest.ReadOnly =
    new Wrapper(impl)
}
