package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteInstallationMediaResponse(
    installationMediaId: Optional[String] = Optional.Absent,
    customAvailabilityZoneId: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    engineInstallationMediaPath: Optional[String] = Optional.Absent,
    osInstallationMediaPath: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    failureCause: Optional[zio.aws.rds.model.InstallationMediaFailureCause] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse = {
    import DeleteInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse
      .builder()
      .optionallyWith(
        installationMediaId.map(value => value: java.lang.String)
      )(_.installationMediaId)
      .optionallyWith(
        customAvailabilityZoneId.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneId)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        engineInstallationMediaPath.map(value => value: java.lang.String)
      )(_.engineInstallationMediaPath)
      .optionallyWith(
        osInstallationMediaPath.map(value => value: java.lang.String)
      )(_.osInstallationMediaPath)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(failureCause.map(value => value.buildAwsValue()))(
        _.failureCause
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteInstallationMediaResponse.ReadOnly =
    zio.aws.rds.model.DeleteInstallationMediaResponse.wrap(buildAwsValue())
}
object DeleteInstallationMediaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteInstallationMediaResponse =
      zio.aws.rds.model.DeleteInstallationMediaResponse(
        installationMediaId.map(value => value),
        customAvailabilityZoneId.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        engineInstallationMediaPath.map(value => value),
        osInstallationMediaPath.map(value => value),
        status.map(value => value),
        failureCause.map(value => value.asEditable)
      )
    def installationMediaId: Optional[String]
    def customAvailabilityZoneId: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def engineInstallationMediaPath: Optional[String]
    def osInstallationMediaPath: Optional[String]
    def status: Optional[String]
    def failureCause
        : Optional[zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly]
    def getInstallationMediaId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("installationMediaId", installationMediaId)
    def getCustomAvailabilityZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneId)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineInstallationMediaPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "engineInstallationMediaPath",
        engineInstallationMediaPath
      )
    def getOsInstallationMediaPath: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("osInstallationMediaPath", osInstallationMediaPath)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFailureCause: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly
    ] = AwsError.unwrapOptionField("failureCause", failureCause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse
  ) extends zio.aws.rds.model.DeleteInstallationMediaResponse.ReadOnly {
    override val installationMediaId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.installationMediaId())
      .map(value => value: String)
    override val customAvailabilityZoneId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZoneId())
        .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val engineInstallationMediaPath: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineInstallationMediaPath())
        .map(value => value: String)
    override val osInstallationMediaPath: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osInstallationMediaPath())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val failureCause
        : Optional[zio.aws.rds.model.InstallationMediaFailureCause.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCause())
        .map(value =>
          zio.aws.rds.model.InstallationMediaFailureCause.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse
  ): zio.aws.rds.model.DeleteInstallationMediaResponse.ReadOnly = new Wrapper(
    impl
  )
}
