package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDbSnapshotRequest(dbSnapshotIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest = {
    import DeleteDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest
      .builder()
      .dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbSnapshotRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbSnapshotRequest.wrap(buildAwsValue())
}
object DeleteDbSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbSnapshotRequest =
      zio.aws.rds.model.DeleteDbSnapshotRequest(dbSnapshotIdentifier)
    def dbSnapshotIdentifier: String
    def getDbSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest
  ) extends zio.aws.rds.model.DeleteDbSnapshotRequest.ReadOnly {
    override val dbSnapshotIdentifier: String =
      impl.dbSnapshotIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest
  ): zio.aws.rds.model.DeleteDbSnapshotRequest.ReadOnly = new Wrapper(impl)
}
