package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDbInstanceRequest(
    dbInstanceIdentifier: String,
    skipFinalSnapshot: Optional[Boolean] = Optional.Absent,
    finalDBSnapshotIdentifier: Optional[String] = Optional.Absent,
    deleteAutomatedBackups: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest = {
    import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .optionallyWith(
        deleteAutomatedBackups.map(value => value: java.lang.Boolean)
      )(_.deleteAutomatedBackups)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbInstanceRequest.wrap(buildAwsValue())
}
object DeleteDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbInstanceRequest =
      zio.aws.rds.model.DeleteDbInstanceRequest(
        dbInstanceIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value),
        deleteAutomatedBackups.map(value => value)
      )
    def dbInstanceIdentifier: String
    def skipFinalSnapshot: Optional[Boolean]
    def finalDBSnapshotIdentifier: Optional[String]
    def deleteAutomatedBackups: Optional[BooleanOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
    def getDeleteAutomatedBackups: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "deleteAutomatedBackups",
        deleteAutomatedBackups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ) extends zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val skipFinalSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalSnapshot())
      .map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalDBSnapshotIdentifier())
        .map(value => value: String)
    override val deleteAutomatedBackups: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteAutomatedBackups())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest
  ): zio.aws.rds.model.DeleteDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
