package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBSecurityGroup(
    ownerId: Optional[String] = Optional.Absent,
    dbSecurityGroupName: Optional[String] = Optional.Absent,
    dbSecurityGroupDescription: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    ec2SecurityGroups: Optional[Iterable[zio.aws.rds.model.EC2SecurityGroup]] =
      Optional.Absent,
    ipRanges: Optional[Iterable[zio.aws.rds.model.IPRange]] = Optional.Absent,
    dbSecurityGroupArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBSecurityGroup = {
    import DBSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBSecurityGroup
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        dbSecurityGroupName.map(value => value: java.lang.String)
      )(_.dbSecurityGroupName)
      .optionallyWith(
        dbSecurityGroupDescription.map(value => value: java.lang.String)
      )(_.dbSecurityGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2SecurityGroups)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(dbSecurityGroupArn.map(value => value: java.lang.String))(
        _.dbSecurityGroupArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBSecurityGroup.ReadOnly =
    zio.aws.rds.model.DBSecurityGroup.wrap(buildAwsValue())
}
object DBSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBSecurityGroup =
      zio.aws.rds.model.DBSecurityGroup(
        ownerId.map(value => value),
        dbSecurityGroupName.map(value => value),
        dbSecurityGroupDescription.map(value => value),
        vpcId.map(value => value),
        ec2SecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSecurityGroupArn.map(value => value)
      )
    def ownerId: Optional[String]
    def dbSecurityGroupName: Optional[String]
    def dbSecurityGroupDescription: Optional[String]
    def vpcId: Optional[String]
    def ec2SecurityGroups
        : Optional[List[zio.aws.rds.model.EC2SecurityGroup.ReadOnly]]
    def ipRanges: Optional[List[zio.aws.rds.model.IPRange.ReadOnly]]
    def dbSecurityGroupArn: Optional[String]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDbSecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupName)
    def getDbSecurityGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbSecurityGroupDescription",
        dbSecurityGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEc2SecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.EC2SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroups)
    def getIpRanges
        : ZIO[Any, AwsError, List[zio.aws.rds.model.IPRange.ReadOnly]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getDbSecurityGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSecurityGroupArn", dbSecurityGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ) extends zio.aws.rds.model.DBSecurityGroup.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val dbSecurityGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSecurityGroupName())
      .map(value => value: String)
    override val dbSecurityGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupDescription())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val ec2SecurityGroups
        : Optional[List[zio.aws.rds.model.EC2SecurityGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.EC2SecurityGroup.wrap(item)
          }.toList
        )
    override val ipRanges: Optional[List[zio.aws.rds.model.IPRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.IPRange.wrap(item)
          }.toList
        )
    override val dbSecurityGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSecurityGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup
  ): zio.aws.rds.model.DBSecurityGroup.ReadOnly = new Wrapper(impl)
}
