package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{TStamp, Integer}
import scala.jdk.CollectionConverters.*
final case class DBProxy(
    dbProxyName: Optional[String] = Optional.Absent,
    dbProxyArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.rds.model.DBProxyStatus] = Optional.Absent,
    engineFamily: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    vpcSubnetIds: Optional[Iterable[String]] = Optional.Absent,
    auth: Optional[Iterable[zio.aws.rds.model.UserAuthConfigInfo]] =
      Optional.Absent,
    roleArn: Optional[String] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    requireTLS: Optional[Boolean] = Optional.Absent,
    idleClientTimeout: Optional[Integer] = Optional.Absent,
    debugLogging: Optional[Boolean] = Optional.Absent,
    createdDate: Optional[TStamp] = Optional.Absent,
    updatedDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxy = {
    import DBProxy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxy
      .builder()
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(dbProxyArn.map(value => value: java.lang.String))(
        _.dbProxyArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(engineFamily.map(value => value: java.lang.String))(
        _.engineFamily
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        vpcSubnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSubnetIds)
      .optionallyWith(
        auth.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.auth)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(
        _.requireTLS
      )
      .optionallyWith(idleClientTimeout.map(value => value: java.lang.Integer))(
        _.idleClientTimeout
      )
      .optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(
        _.debugLogging
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(updatedDate.map(value => TStamp.unwrap(value): Instant))(
        _.updatedDate
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxy.ReadOnly =
    zio.aws.rds.model.DBProxy.wrap(buildAwsValue())
}
object DBProxy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxy = zio.aws.rds.model.DBProxy(
      dbProxyName.map(value => value),
      dbProxyArn.map(value => value),
      status.map(value => value),
      engineFamily.map(value => value),
      vpcId.map(value => value),
      vpcSecurityGroupIds.map(value => value),
      vpcSubnetIds.map(value => value),
      auth.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleArn.map(value => value),
      endpoint.map(value => value),
      requireTLS.map(value => value),
      idleClientTimeout.map(value => value),
      debugLogging.map(value => value),
      createdDate.map(value => value),
      updatedDate.map(value => value)
    )
    def dbProxyName: Optional[String]
    def dbProxyArn: Optional[String]
    def status: Optional[zio.aws.rds.model.DBProxyStatus]
    def engineFamily: Optional[String]
    def vpcId: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def vpcSubnetIds: Optional[List[String]]
    def auth: Optional[List[zio.aws.rds.model.UserAuthConfigInfo.ReadOnly]]
    def roleArn: Optional[String]
    def endpoint: Optional[String]
    def requireTLS: Optional[Boolean]
    def idleClientTimeout: Optional[Integer]
    def debugLogging: Optional[Boolean]
    def createdDate: Optional[TStamp]
    def updatedDate: Optional[TStamp]
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getDbProxyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyArn", dbProxyArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.DBProxyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEngineFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineFamily", engineFamily)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getVpcSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIds)
    def getAuth: ZIO[Any, AwsError, List[
      zio.aws.rds.model.UserAuthConfigInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("auth", auth)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRequireTLS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxy
  ) extends zio.aws.rds.model.DBProxy.ReadOnly {
    override val dbProxyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyName())
      .map(value => value: String)
    override val dbProxyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyArn())
      .map(value => value: String)
    override val status: Optional[zio.aws.rds.model.DBProxyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.DBProxyStatus.wrap(value))
    override val engineFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineFamily())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSubnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val auth
        : Optional[List[zio.aws.rds.model.UserAuthConfigInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auth())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.UserAuthConfigInfo.wrap(item)
          }.toList
        )
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val requireTLS: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requireTLS())
      .map(value => value: Boolean)
    override val idleClientTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.idleClientTimeout())
      .map(value => value: Integer)
    override val debugLogging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.debugLogging())
      .map(value => value: Boolean)
    override val createdDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val updatedDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxy
  ): zio.aws.rds.model.DBProxy.ReadOnly = new Wrapper(impl)
}
