package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomAvailabilityZone(
    customAvailabilityZoneId: Optional[String] = Optional.Absent,
    customAvailabilityZoneName: Optional[String] = Optional.Absent,
    customAvailabilityZoneStatus: Optional[String] = Optional.Absent,
    vpnDetails: Optional[zio.aws.rds.model.VpnDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CustomAvailabilityZone = {
    import CustomAvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CustomAvailabilityZone
      .builder()
      .optionallyWith(
        customAvailabilityZoneId.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneId)
      .optionallyWith(
        customAvailabilityZoneName.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneName)
      .optionallyWith(
        customAvailabilityZoneStatus.map(value => value: java.lang.String)
      )(_.customAvailabilityZoneStatus)
      .optionallyWith(vpnDetails.map(value => value.buildAwsValue()))(
        _.vpnDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CustomAvailabilityZone.ReadOnly =
    zio.aws.rds.model.CustomAvailabilityZone.wrap(buildAwsValue())
}
object CustomAvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CustomAvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CustomAvailabilityZone =
      zio.aws.rds.model.CustomAvailabilityZone(
        customAvailabilityZoneId.map(value => value),
        customAvailabilityZoneName.map(value => value),
        customAvailabilityZoneStatus.map(value => value),
        vpnDetails.map(value => value.asEditable)
      )
    def customAvailabilityZoneId: Optional[String]
    def customAvailabilityZoneName: Optional[String]
    def customAvailabilityZoneStatus: Optional[String]
    def vpnDetails: Optional[zio.aws.rds.model.VpnDetails.ReadOnly]
    def getCustomAvailabilityZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneId)
    def getCustomAvailabilityZoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "customAvailabilityZoneName",
        customAvailabilityZoneName
      )
    def getCustomAvailabilityZoneStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "customAvailabilityZoneStatus",
        customAvailabilityZoneStatus
      )
    def getVpnDetails
        : ZIO[Any, AwsError, zio.aws.rds.model.VpnDetails.ReadOnly] =
      AwsError.unwrapOptionField("vpnDetails", vpnDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CustomAvailabilityZone
  ) extends zio.aws.rds.model.CustomAvailabilityZone.ReadOnly {
    override val customAvailabilityZoneId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZoneId())
        .map(value => value: String)
    override val customAvailabilityZoneName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZoneName())
        .map(value => value: String)
    override val customAvailabilityZoneStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAvailabilityZoneStatus())
        .map(value => value: String)
    override val vpnDetails: Optional[zio.aws.rds.model.VpnDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnDetails())
        .map(value => zio.aws.rds.model.VpnDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CustomAvailabilityZone
  ): zio.aws.rds.model.CustomAvailabilityZone.ReadOnly = new Wrapper(impl)
}
