package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCustomAvailabilityZoneRequest(
    customAvailabilityZoneName: String,
    existingVpnId: Optional[String] = Optional.Absent,
    newVpnTunnelName: Optional[String] = Optional.Absent,
    vpnTunnelOriginatorIP: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest = {
    import CreateCustomAvailabilityZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest
      .builder()
      .customAvailabilityZoneName(customAvailabilityZoneName: java.lang.String)
      .optionallyWith(existingVpnId.map(value => value: java.lang.String))(
        _.existingVpnId
      )
      .optionallyWith(newVpnTunnelName.map(value => value: java.lang.String))(
        _.newVpnTunnelName
      )
      .optionallyWith(
        vpnTunnelOriginatorIP.map(value => value: java.lang.String)
      )(_.vpnTunnelOriginatorIP)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateCustomAvailabilityZoneRequest.ReadOnly =
    zio.aws.rds.model.CreateCustomAvailabilityZoneRequest.wrap(buildAwsValue())
}
object CreateCustomAvailabilityZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateCustomAvailabilityZoneRequest =
      zio.aws.rds.model.CreateCustomAvailabilityZoneRequest(
        customAvailabilityZoneName,
        existingVpnId.map(value => value),
        newVpnTunnelName.map(value => value),
        vpnTunnelOriginatorIP.map(value => value)
      )
    def customAvailabilityZoneName: String
    def existingVpnId: Optional[String]
    def newVpnTunnelName: Optional[String]
    def vpnTunnelOriginatorIP: Optional[String]
    def getCustomAvailabilityZoneName: ZIO[Any, Nothing, String] =
      ZIO.succeed(customAvailabilityZoneName)
    def getExistingVpnId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("existingVpnId", existingVpnId)
    def getNewVpnTunnelName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newVpnTunnelName", newVpnTunnelName)
    def getVpnTunnelOriginatorIP: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnTunnelOriginatorIP", vpnTunnelOriginatorIP)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest
  ) extends zio.aws.rds.model.CreateCustomAvailabilityZoneRequest.ReadOnly {
    override val customAvailabilityZoneName: String =
      impl.customAvailabilityZoneName(): String
    override val existingVpnId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.existingVpnId())
      .map(value => value: String)
    override val newVpnTunnelName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newVpnTunnelName())
      .map(value => value: String)
    override val vpnTunnelOriginatorIP: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnTunnelOriginatorIP())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest
  ): zio.aws.rds.model.CreateCustomAvailabilityZoneRequest.ReadOnly =
    new Wrapper(impl)
}
