package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UserAuthConfig(
    description: scala.Option[String] = None,
    userName: scala.Option[String] = None,
    authScheme: scala.Option[zio.aws.rds.model.AuthScheme] = None,
    secretArn: scala.Option[String] = None,
    iamAuth: scala.Option[zio.aws.rds.model.IAMAuthMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.UserAuthConfig = {
    import UserAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.UserAuthConfig
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(authScheme.map(value => value.unwrap))(_.authScheme)
      .optionallyWith(secretArn.map(value => value: java.lang.String))(
        _.secretArn
      )
      .optionallyWith(iamAuth.map(value => value.unwrap))(_.iamAuth)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.UserAuthConfig.ReadOnly =
    zio.aws.rds.model.UserAuthConfig.wrap(buildAwsValue())
}
object UserAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.UserAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.UserAuthConfig =
      zio.aws.rds.model.UserAuthConfig(
        description.map(value => value),
        userName.map(value => value),
        authScheme.map(value => value),
        secretArn.map(value => value),
        iamAuth.map(value => value)
      )
    def description: scala.Option[String]
    def userName: scala.Option[String]
    def authScheme: scala.Option[zio.aws.rds.model.AuthScheme]
    def secretArn: scala.Option[String]
    def iamAuth: scala.Option[zio.aws.rds.model.IAMAuthMode]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getAuthScheme: ZIO[Any, AwsError, zio.aws.rds.model.AuthScheme] =
      AwsError.unwrapOptionField("authScheme", authScheme)
    def getSecretArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getIamAuth: ZIO[Any, AwsError, zio.aws.rds.model.IAMAuthMode] =
      AwsError.unwrapOptionField("iamAuth", iamAuth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.UserAuthConfig
  ) extends zio.aws.rds.model.UserAuthConfig.ReadOnly {
    override val description: scala.Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val userName: scala.Option[String] =
      scala.Option(impl.userName()).map(value => value: String)
    override val authScheme: scala.Option[zio.aws.rds.model.AuthScheme] = scala
      .Option(impl.authScheme())
      .map(value => zio.aws.rds.model.AuthScheme.wrap(value))
    override val secretArn: scala.Option[String] =
      scala.Option(impl.secretArn()).map(value => value: String)
    override val iamAuth: scala.Option[zio.aws.rds.model.IAMAuthMode] = scala
      .Option(impl.iamAuth())
      .map(value => zio.aws.rds.model.IAMAuthMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.UserAuthConfig
  ): zio.aws.rds.model.UserAuthConfig.ReadOnly = new Wrapper(impl)
}
