package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartActivityStreamResponse(
    kmsKeyId: scala.Option[String] = None,
    kinesisStreamName: scala.Option[String] = None,
    status: scala.Option[zio.aws.rds.model.ActivityStreamStatus] = None,
    mode: scala.Option[zio.aws.rds.model.ActivityStreamMode] = None,
    applyImmediately: scala.Option[Boolean] = None,
    engineNativeAuditFieldsIncluded: scala.Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartActivityStreamResponse = {
    import StartActivityStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kinesisStreamName.map(value => value: java.lang.String))(
        _.kinesisStreamName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        engineNativeAuditFieldsIncluded.map(value => value: java.lang.Boolean)
      )(_.engineNativeAuditFieldsIncluded)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartActivityStreamResponse.ReadOnly =
    zio.aws.rds.model.StartActivityStreamResponse.wrap(buildAwsValue())
}
object StartActivityStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartActivityStreamResponse =
      zio.aws.rds.model.StartActivityStreamResponse(
        kmsKeyId.map(value => value),
        kinesisStreamName.map(value => value),
        status.map(value => value),
        mode.map(value => value),
        applyImmediately.map(value => value),
        engineNativeAuditFieldsIncluded.map(value => value)
      )
    def kmsKeyId: scala.Option[String]
    def kinesisStreamName: scala.Option[String]
    def status: scala.Option[zio.aws.rds.model.ActivityStreamStatus]
    def mode: scala.Option[zio.aws.rds.model.ActivityStreamMode]
    def applyImmediately: scala.Option[Boolean]
    def engineNativeAuditFieldsIncluded: scala.Option[BooleanOptional]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kinesisStreamName", kinesisStreamName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMode: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "engineNativeAuditFieldsIncluded",
      engineNativeAuditFieldsIncluded
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ) extends zio.aws.rds.model.StartActivityStreamResponse.ReadOnly {
    override val kmsKeyId: scala.Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val kinesisStreamName: scala.Option[String] =
      scala.Option(impl.kinesisStreamName()).map(value => value: String)
    override val status: scala.Option[zio.aws.rds.model.ActivityStreamStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val mode: scala.Option[zio.aws.rds.model.ActivityStreamMode] =
      scala
        .Option(impl.mode())
        .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val applyImmediately: scala.Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val engineNativeAuditFieldsIncluded
        : scala.Option[BooleanOptional] = scala
      .Option(impl.engineNativeAuditFieldsIncluded())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ): zio.aws.rds.model.StartActivityStreamResponse.ReadOnly = new Wrapper(impl)
}
